;;;   Programm:      ACM-LAYERISOLIEREN.LSP
;;;   Befehlsaufruf: ACM-LAYERISOLIEREN
;;;   Funktion:      Isoliert Layer, indem die restlichen Layer deaktiviert oder gefroren
;;;                  werden.
;;;   Autor:         Gerhard Rampf
;;;                  Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;;                  Liebigstr. 3 A
;;;                  86399 Bobingen
;;;                  E-Mail: rampf@geracad.de
;;;   Datum:         27.07.2023
;;;   Plattform:     Alle AutoCAD-Versionen ab Version 2005
(defun c:acm-layerisolieren ( / lis73 lis74 lis75 sil01 sil02 sil03 sil04 sil05 sil06 sil07 sil08 sil09 sil10 sil11 sil12 sil13 sil14)
    (defun sil01 (lis01 lis02 / lis19 lis16 lis17 lis18)
      (setq lis16 (strlen lis01))
        (if (> lis16 lis02)
          (progn
            (setq lis17 (substr lis01 1 (/ (- lis02 3) 2)))
            (setq lis18 (substr lis01 (- lis16 (1- (/ (- lis02 3) 2)))))
            (setq lis19 (strcat lis17 "\056\056\056" lis18))
          )
        )
        (if lis19
          lis19
          lis01
        )
    )
    (defun sil02 (lis03 lis04 lis05 / lis20 lis21 lis22 lis23 lis24 lis25 lis26 lis27 lis28 lis29 lis30)
      (setq lis20 (car lis03))
      (setq lis21 lis20)
        (if (vl-string-search "|" lis20)
          (progn
            (setq lis20 (getvar "CLAYER"))
            (setq lis22 1)
          )
        )
      (setq lis23 lis03)
      (setq lis24 lis03)
      (setq lis25 (length lis03))
      (sssetfirst nil nil)
      (setq lis26 (getvar "CMDECHO"))
      (setvar "CMDECHO" 0)
      (setq lis27 (getvar "EXPERT"))
      (setvar "EXPERT" 1)
      (setq lis28 (nth lis05 (list "_off" "_freeze")))
      (setq lis29 (nth lis05 (list "_on" "_thaw")))
      (command "._-layer" "_thaw" "*" "_on" "*" "_set" lis20 lis28 "*")
        (while lis03
          (command lis29 (car lis03))
          (setq lis03 (cdr lis03))
        )
      (command "")
        (if (= lis04 1)
          (sil03 lis24)
        )
        (if (not (vl-position (setq lis30 (getvar "CLAYER")) lis23))
          (command "._-layer" "_off" lis30 "")
        )
      (setvar "EXPERT" lis27)
      (setvar "CMDECHO" lis26)
        (if (= lis05 1)
          (vla-regen (vla-get-ActiveDocument (vlax-get-acad-object)) acActiveViewport)
        )
        (if (= lis25 1)
            (prompt (strcat "\nLayer \042" (sil01 lis21 25) "\042 wurde isoliert. "))
            (prompt (strcat "\n" (itoa lis25) " Layer wurden isoliert. "))
        )
        (if lis22
          (prompt (strcat "Layer \042" (sil01 (getvar "CLAYER") 25) "\042 (deaktiviert) ist aktuell. "))
          (prompt (strcat "Layer \042" (sil01 (getvar "CLAYER") 25) "\042 ist aktuell. "))
        )
      (prompt "Mit ACM-ISOLIERUNGAUFHEBEN wird die Isolierung aufgehoben. ")
    )
    (defun sil03 (lis03 / lis31)
      (command "._-layer")
        (while lis03
          (command "_unlock" (car lis03))
          (setq lis03 (cdr lis03))
        )
      (command "")
    )
    (defun sil04 ( / lis31 lis00 lis32)
      (setq lis31 (vla-get-Layers (vla-get-ActiveDocument (vlax-get-acad-object))))
        (vlax-for lis00 lis31
          (setq lis32 (cons (vlax-get lis00 'Name) lis32))
        )
      (acad_strlsort lis32)
    )
    (defun sil05 (lis06 lis07 / lis33 lis34 lis35 lis36)
      (setq lis33 "")
        (while lis06
            (if (setq lis34 (vl-position (car lis06) lis07))
              (setq lis35 (cons lis34 lis35))
            )
          (setq lis06 (cdr lis06))
        )
        (if lis35
          (progn
            (setq lis36 (vl-sort lis35 '<))
              (while lis36
                (setq lis33 (strcat lis33 (itoa (car lis36)) " "))
                (setq lis36 (cdr lis36))
              )
          )
        )
      (vl-string-trim " " lis33)
    )
    (defun sil06 ( / lis37 lis25 lis38 lis39 lis40 lis41 lis42 lis43)
        (if (setq lis37 (ssget "_i"))
          (progn
            (setq lis25 (sslength lis37))
            (setq lis38 -1)
              (repeat lis25
                (setq lis39 (ssname lis37 (setq lis38 (1+ lis38))))
                (setq lis40 (cdr (assoc 8 (entget lis39))))
                (setq lis41 (strcase lis40))
                  (if (not (vl-position lis41 lis42))
                    (progn
                      (setq lis42 (cons lis41 lis42))
                      (setq lis43 (cons lis40 lis43))
                    )
                  )
              )
          )
        )
      lis43
    )
    (defun sil07 ( / lis44 lis45 lis48 lis49 lis50 lis51 lis52 lis53 lis54 lis55 lis56)
        (if (setq lis44 (sil08))
          (progn
            (setq lis45 (load_dialog lis44))
              (if (not (new_dialog "acm_623" lis45))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list lis44))
              (if (not (vl-position acm623layerisolieren7ajww20 (list "0" "1")))
                (setq acm623layerisolieren7ajww20 "0")
              )
              (if (not (vl-position acm623layerisolieren7ajww21 (list "0" "1")))
                (setq acm623layerisolieren7ajww21 "0")
              )
            (setq lis48 (sil04))
            (start_list "lb_01")
            (mapcar 'add_list lis48)
            (end_list)
              (if (setq lis49 (sil06))
                (progn
                  (setq lis50 (sil05 lis49 lis48))
                  (set_tile "lb_01" lis50)
                )
              )
              (if (= (length (sil09 (get_tile "lb_01") " ")) 0)
                (mode_tile "b_01" 1)
              )
              (if (= (setq lis51 (sil05 acm623layerisolieren7ajww22 lis48)) "")
                (mode_tile "b_03" 1)
              )
            (set_tile "tg_01" acm623layerisolieren7ajww20)
              (if (= acm623layerisolieren7ajww21 "0")
                (set_tile "rb_01" "1")
                (set_tile "rb_02" "1")
              )
            (action_tile "b_03" "(mode_tile \"b_01\" 0) (set_tile \"lb_01\" \"\") (set_tile \"lb_01\" lis51)")
            (action_tile "lb_01" "(if (> (length (sil09 $value \" \")) 250) (progn (alert \"Ungltige Auswahl. Bitte maximal 250 Eintrge whlen.\") (set_tile $key \"0\") (set_tile $key \"\") (mode_tile \"b_01\" 1)) (progn (if (= $value \"\") (mode_tile \"b_01\" 1) (mode_tile \"b_01\" 0)))))")
            (action_tile "b_00" "(set_tile \"eb_01\" (setq lis52 (vl-string-trim \" \" (get_tile \"eb_01\")))) (sil12 lis48 lis52)")
            (action_tile "eb_01" "(if (= $reason 1) (progn (set_tile $key (setq lis53 (vl-string-trim \" \" $value))) (sil12 lis48 lis53)))")
            (action_tile "b_01" "(setq acm623layerisolieren7ajww20 (get_tile \"tg_01\")) (setq acm623layerisolieren7ajww21 (get_tile \"rb_02\")) (setq lis54 (sil09 (setq lis55 (get_tile \"lb_01\")) \" \")) (setq lis54 (mapcar 'atoi lis54)) (while lis54 (setq lis56 (cons (nth (car lis54) lis48) lis56)) (setq lis54 (cdr lis54))) (setq acm623layerisolieren7ajww22 (setq lis56 (reverse lis56))) (done_dialog)")
            (action_tile "b_02" "(setq lis56 nil) (done_dialog)")
            (start_dialog)
            (unload_dialog lis45)
          )
        )
      lis56
    )
    (defun sil08 ( / lis58 lis59 lis60)
      (if
        (and
          (setq lis58 (vl-filename-mktemp "acm.dcl"))
          (setq lis59 (open lis58 "w"))
        )
          (progn
            (setq lis60
              (list
                "acm_623"
                ":dialog{label=\042Layer isolieren\042;"
                ":spacer{height=0.4;}"
                ":row{height=21;"
                ":column{width=35;"
                ":list_box{key=\042lb_01\042;multiple_select=true;}}"
                ":column{width=0;"
                ":button{key=\042b_03\042;label=\042&Vorh. Auswahl\042;}"
                ":spacer{height=0.2;}"
                ":button{key=\042b_00\042;label=\042&Suchen nach:\042;}"
                ":edit_box{key=\042eb_01\042;}"
                ":spacer{height=0.2;}"
                ":text{label=\042Methode:\042;}"
                ":row{"
                ":spacer{width=0.2;}"
                ":column{width=0;"
                ":radio_button{key=\042rb_01\042;label=\042&Deaktivieren\042;}"
                ":radio_button{key=\042rb_02\042;label=\042&Frieren\042;}}}"
                ":spacer{height=0.2;}"
                ":toggle{key=\042tg_01\042;label=\042&Entsperren\042;}"
                ":spacer{height=0.55;}"
                ":button{key=\042b_01\042;label=\042OK\042;is_default=true;}"
                ":button{key=\042b_02\042;label=\042Abbrechen\042;is_cancel=true;}}}}"
              )
            )
              (while lis60
                (write-line (car lis60) lis59)
                (setq lis60 (cdr lis60))
              )
            (setq lis59 (close lis59))
            lis58
          )
          nil
      )
    )
    (defun sil09 (lis08 lis09 / lis61 lis34 lis62 lis56)
      (if
        (and
          (= (type lis08) 'STR)
          (= (type lis09) 'STR)
        )
          (progn
            (setq lis61 (sil10 lis08 (list lis09)))
            (setq lis34 (sil11 lis61 lis09))
              (if lis34
                (progn
                  (setq lis62 (substr lis61 1 (1- lis34)))
                  (setq lis61 (sil10 (substr lis61 (1+ (strlen lis62))) (list lis09)))
                  (setq lis56 (cons lis62 lis56))
                )
              )
            (setq lis34 (sil11 lis61 lis09))
              (while lis34
                (setq lis62 (substr lis61 1 (1- lis34)))
                (setq lis61 (sil10 (substr lis61 (1+ (strlen lis62))) (list lis09)))
                (setq lis56 (cons lis62 lis56))
                (setq lis34 (sil11 lis61 lis09))
              )
              (if (> (strlen lis61) 0)
                (setq lis56 (cons lis61 lis56))
              )
          )
      )
      (if lis56
        (reverse lis56)
        nil
      )
    )
    (defun sil10 (lis10 lis11 / lis16 lis63 lis64 lis65)
      (setq lis16 (strlen lis10))
      (setq lis63 (substr lis10 1 1))
      (setq lis64 0)
        (while
          (and
            (/= (member lis63 lis11) nil)
            (/= lis64 lis16)
          )
            (setq lis10 (substr lis10 2))
            (setq lis63 (substr lis10 1 1))
            (setq lis64 (+ lis64 1))
        )
        (if (/= lis64 lis16)
          (progn
            (setq lis16 (strlen lis10))
            (setq lis65 (substr lis10 lis16 1))
            (setq lis64 lis16)
              (while
                (and
                  (/= (member lis65 lis11) nil)
                  (/= lis64 0)
                )
                  (setq lis10 (substr lis10 1 lis64))
                  (setq lis65 (substr lis10 lis64 1))
                  (setq lis64 (- lis64 1))
              )
          )
        )
      lis10
    )
    (defun sil11 (lis10 lis12 / lis16 lis66 lis63 lis34)
      (setq lis16 (strlen lis10))
      (setq lis66 1)
        (while (<= lis66 lis16)
          (setq lis63 (substr lis10 lis66 1))
            (if (/= lis63 lis12)
              (progn
                (setq lis34 nil)
                (setq lis66 (1+ lis66))
              )
            )
            (if (= lis63 lis12)
              (progn
                (setq lis34 lis66)
                (setq lis66 (1+ lis16))
              )
            )
        )
      lis34
    )
    (defun sil12 (lis13 lis14 / lis67 lis68 lis69 lis64 lis71 lis70)
      (if (= lis14 "")
        (progn
          (alert "Keine Eingabe fr \042Suchen nach\042.")
          (mode_tile "eb_01" 2)
        )
        (progn
          (setq lis67 (mapcar 'strcase lis13))
          (setq lis68 (strcase lis14))
          (setq lis69 "")
          (setq lis64 -1)
          (setq lis70 0)
            (repeat (length lis67)
              (setq lis64 (1+ lis64))
                (if (wcmatch (nth lis64 lis67) lis68)
                  (progn
                    (setq lis69 (strcat lis69 (itoa lis64) " "))
                    (setq lis70 (1+ lis70))
                  )
                )
            )
            (if
              (and
                (<= lis70 250)
                (/= (setq lis71 (vl-string-trim " " lis69)) "")
              )
                (progn
                  (set_tile "lb_01" "")
                  (set_tile "lb_01" lis71)
                  (mode_tile "b_01" 0)
                )
                (progn
                  (set_tile "lb_01" "0")
                  (set_tile "lb_01" "")
                    (if (> lis70 250)
                      (alert "Ungltige Auswahl. Mehr als 250 entsprechende Layer gefunden.")
                      (alert "Es wurden keine entsprechenden Layer gefunden.")
                    )
                  (mode_tile "eb_01" 2)
                  (mode_tile "b_01" 1)
                )
            )
        )
      )
    )
    (defun sil13 ( / lis72)
      (setq lis72 (strcase (getvar "PRODUCT")))
        (if
          (and
            (= lis72 "AUTOCAD")
            (getvar "HPDRAWORDER")
          )
            (setq lis56 T)
            (setq lis56 nil)
        )
        (if (not lis56)
          (alert "\042acm-layerisolieren\042 kann nur unter AutoCAD ab Version 2005 verwendet werden.")
        )
      lis56
    )
    (defun sil14 (lis15 / )
        (if lis74 (setq *error* lis74))
        (if lis27
          (vl-catch-all-apply 'setvar (list "EXPERT" lis27))
        )
        (if lis26
          (vl-catch-all-apply 'setvar (list "CMDECHO" lis26))
        )
      (vla-EndUndoMark (vla-get-ActiveDocument (vlax-get-acad-object)))
      (princ)
    )
  (if
    (and
      (sil13)
      (= (getvar "TILEMODE") 1)
    )
    (progn
      (vl-load-com)
      (setq lis73 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (setq lis74 *error*)
      (setq *error* sil14)
      (vla-EndUndoMark lis73)
      (vla-StartUndoMark lis73)
        (if (setq lis75 (sil07))
          (sil02 lis75 (atoi acm623layerisolieren7ajww20) (atoi acm623layerisolieren7ajww21))
        )
        (if lis74
          (setq *error* lis74)
          (setq *error* nil)
        )
      (vla-EndUndoMark lis73)
    )
    (progn
      (if (/= (getvar "TILEMODE") 1)
        (alert "\042acm-layerisolieren\042 kann nur im Modellbereich verwendet werden.")
      )
    )
  )
  (princ)
)
(defun c:acm-isolierungaufheben ( / lis27 lis26)
  (setq lis27 (getvar "EXPERT"))
  (setq lis26 (getvar "CMDECHO"))
  (setvar "EXPERT" 1)
  (setvar "CMDECHO" 0)
  (vl-cmdf "._-layer" "_thaw" "*" "_on" "*" "")
  (setvar "EXPERT" lis27)
  (setvar "CMDECHO" lis26)
  (princ)
)
(terpri)
(princ "\nAutoLISP-Tools ACM-LAYERISOLIEREN und ACM-ISOLIERUNGAUFHEBEN (Copyright  2023 Gerhard Rampf) geladen.")
(princ "\nRufen Sie die Befehle mit ACM-LAYERISOLIEREN bzw. ACM-ISOLIERUNGAUFHEBEN auf.")
